%\NeedsTeXFormat{LaTeX2e}
%\ProvidesClass{FNScls}

\LoadClass[a4paper,10pt]{article}
%\documentclass[oneside, a4paper, onecolumn, 10pt]{article}


\RequirePackage[a4paper,left=2cm,right=1.8cm,top=2.5cm,bottom=2.7cm]{geometry}
\usepackage{helvet}
\renewcommand{\familydefault}{\sfdefault} 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Packages
\usepackage{array}
\usepackage{graphicx}
\usepackage[utf8]{inputenc}
\usepackage[bookmarks=true,bookmarksopen=true,
           bookmarksnumbered=true,
           colorlinks=true,citecolor=black,linkcolor=black                 
           ]{hyperref}
\usepackage[square,sort&compress,comma,numbers]{natbib}
%\setcitestyle{numbers}
\renewcommand\bibsection{\subsection*{\refname}}
\renewcommand{\bibfont}{\footnotesize}
\setlength{\bibsep}{5pt}
%\bibpunct{[}{]}{,}{a}{,}{,} 


\usepackage{xcolor}
\hypersetup{
    colorlinks,
    linkcolor={red!50!black},
    citecolor={blue!50!black},
    urlcolor={blue!80!black}
}


\RequirePackage{authblk}
\renewcommand{\Authands}{, }
\renewcommand{\Authfont}{\bfseries}

%\RequirePackage[usenames,dvipsnames,table]{xcolor}
%\definecolor{epicolor}{RGB}{0,0,200}

%\RequirePackage[
%    bookmarksnumbered=true,bookmarksopen=true,
%	unicode=true,colorlinks=true,linktoc=all,%linktoc=page
%	linkcolor=epicolor,citecolor=epicolor,filecolor=epicolor,urlcolor=epicolor,
%	pdfstartview=FitH
%]{hyperref}

\RequirePackage{parskip}
\RequirePackage{graphicx}
\RequirePackage{fancyhdr}

% number lines
\RequirePackage{lineno}

% remove page numbers
\pagenumbering{gobble}



\newcommand\@confshortname{}
\newcommand\@conffullname{}
\newcommand\@confdate{}
\newcommand\@confmonth{}
\newcommand\@confyear{}
\newcommand\@confcity{}
\newcommand\@confcountry{}
\newcommand\@papernum{}
\newcommand{\confshortname}[1]{\gdef\@confshortname{#1}}
\newcommand{\conffullname}[1]{\gdef\@conffullname{#1}}
\newcommand{\confdate}[1]{\gdef\@confdate{#1}}
\newcommand{\confmonth}[1]{\gdef\@confmonth{#1}}
\newcommand{\confyear}[1]{\gdef\@confyear{#1}}
\newcommand{\confcountry}[1]{\gdef\@confcountry{#1}}
\newcommand{\confcity}[1]{\gdef\@confcity{#1}}
\newcommand{\papernum}[1]{\gdef\@papernum{#1}}



 

\RequirePackage[largestsep]{titlesec}
\titleformat{\section}{\normalfont\normalsize\bfseries}{\thesection}{1em}{\MakeUppercase}
\titleformat{\subsection}{\normalfont\normalsize\bfseries}{\thesubsection}{1em}{}
\titleformat{\subsubsection}{\normalfont\normalsize\itshape}{\thesubsubsection}{1em}{}
\titleformat{\paragraph}[runin]{\normalfont\normalsize\bfseries}{\theparagraph}{1em}{}[. \mbox{}]
\titleformat{\subparagraph}[runin]{\normalfont\normalsize\itshape}{\thesubparagraph}{1em}{}[. \mbox{}]

\titlespacing*{\section}{0pt}{5.5ex plus 1ex minus .2ex}{1.3ex plus .2ex}


\renewcommand{\thesection}{\arabic{section}}
\renewcommand{\thesubsection}{\arabic{section}.\arabic{subsection}}




\RequirePackage{listings}	% must be loaded after babel
\lstset{numbers=left,numberstyle=\scriptsize,basicstyle=\small,xleftmargin=3ex,flexiblecolumns=true}

\RequirePackage{float} % must be loaded before caption package
\floatstyle{ruled}
\newfloat{listing}{tbph}{lol}[section]
\floatname{listing}{Algorithme}
\renewcommand{\floatpagefraction}{0.8}
\renewcommand{\bottomfraction}{0.5}
\renewcommand{\topfraction}{0.5}
\renewcommand{\textfraction}{0.1}

\RequirePackage{rotating,subfigure} % must be loaded before caption package
\RequirePackage[small]{caption}
\setlength{\abovecaptionskip}{1ex plus 0.5ex minus 0.2ex}

% ------------------------------------------------------------- %

% corresponding author
\newcommand{\@corrauthor}{}
\newcommand{\corrauthor}[2]{\renewcommand{\@corrauthor}{*contact: \href{mailto:}{#1} \if\relax#2\relax\else (\texttt{#2}) \fi}}

% maketitle identical to standard article title, except for pagestyle
\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    %\thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}

\def\@maketitle{%
  \newpage
  \null
  %\vspace*{-26pt}  
%  \newpage
%  \null
   \vspace{-2cm}
 % \includegraphics[height=2.5cm]{tudelftlogo.pdf}\hfill 
 \vbox{\hbox to 1\textwidth{\begin{tabular}{@{}c@{\hskip3pc}}
   \hbox to 36pt{\vbox to 36pt{\vss\hsize26pt\vss}}\end{tabular}\hss
   \vspace{0cm}\vbox{\hsize37pc\small\sf
   %\vskip\baselineskip%
  %\bannerfnt 
  \begin{flushright}% added flushright to properly wrap long conference names
 \hfill  \@conffullname\par
 % \hfill \@confshortname\par
  \hfill \@confmonth\ \@confdate, \@confyear, \@confcity, \@confcountry
 % \vskip.5in
 % \hfill {\pnumfnt\@papernum}
%  
\end{flushright}
}
  \hskip1pc}}
  \vskip 1em%
  %\vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\large\bfseries \@title \par}%
    \vskip 1.5em%
    {\small
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author\\[\affilsep]
        \@corrauthor \\ \\
      \end{tabular}\par}%
  \end{center}%
  \par
}

\renewcommand{\abstract}[1]{%
  \vspace{9pt}%
  \begingroup
  \leftskip0.5cm
  \rightskip\leftskip
  {\small
  {\bfseries\MakeUppercase \abstractname\vspace{-.5em}\vspace{\z@}}\par%
  #1}%
  \par
  \endgroup}

 
